
// TYPES
export const types = {
    LOGIN_SUCCESS: "AUTH/LOGIN_SUCCESS",
    LOGOUT: "AUTH/LOGOUT",
};

// INITIAL STATE
export const initialState = {
    token: null,
    user: null,
};

// REDUCER
export default (state = initialState, action) => {
    switch (action.type) {
        case types.LOGIN_SUCCESS:
            return {
                ...state,
                token: action.payload.token,
                user: action.payload.user
            };

        case types.LOGOUT:
            return {
                ...state,
                token: null,
                user: null,
            };

        default:
            return state
    }
}

// ACTIONS
export const actions = {

    loginSuccess: (token, user) => {
        return {
            type: types.LOGIN_SUCCESS,
            payload: {
                token,
                user
            }
        };
    },

    logout: () => {
        return {
            type: types.LOGOUT,
        }
    }
};